<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Updates;

use Piwik\Updater;
use Piwik\Updates;
use Piwik\Updater\Migration\Factory as MigrationFactory;

class Updates_0_2_13 extends Updates
{
    /**
     * @var MigrationFactory
     */
    private $migration;

    public function __construct(MigrationFactory $factory)
    {
        $this->migration = $factory;
    }

    public function getMigrations(Updater $updater)
    {
        return array(
            $this->migration->db->dropTable('option'),
            $this->migration->db->createTable('option', array(
                'option_name'  => 'VARCHAR( 64 ) NOT NULL' ,
                'option_value' => 'LONGTEXT NOT NULL' ,
                'autoload' => "TINYINT NOT NULL DEFAULT '1'",
            )),
            $this->migration->db->addPrimaryKey('option', 'option_name'),
        );
    }

    public function doUpdate(Updater $updater)
    {
        $updater->executeMigrations(__FILE__, $this->getMigrations($updater));
    }
}
