<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Updates;

use Piwik\Updater;
use Piwik\Updates as PiwikUpdates;
use Piwik\Updater\Migration;
use Piwik\Updater\Migration\Factory as MigrationFactory;

/**
 * Update for version 4.12.0-b2
 */
class Updates_4_12_0_b2 extends PiwikUpdates
{
    /**
     * @var MigrationFactory
     */
    private $migration;

    public function __construct(MigrationFactory $factory)
    {
        $this->migration = $factory;
    }

    /**
     *
     * @return Migration[]
     */
    public function getMigrations(Updater $updater)
    {
        $uniqueIndex = $this->migration->db->addUniqueKey('user', 'email', 'uniq_email');

        // if for some reason a duplicate email exists we simply ignore the error and don't add the index.
        $uniqueIndex->addErrorCodeToIgnore(Migration\Db::ERROR_CODE_DUPLICATE_ENTRY);

        return [$uniqueIndex];
    }

    public function doUpdate(Updater $updater)
    {
        $updater->executeMigrations(__FILE__, $this->getMigrations($updater));
    }
}
