<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

namespace Piwik\Updates;

use Piwik\Updater;
use Piwik\Updates;
use Piwik\Updater\Migration\Factory as MigrationFactory;

class Updates_0_2_24 extends Updates
{
    /**
     * @var MigrationFactory
     */
    private $migration;

    public function __construct(MigrationFactory $factory)
    {
        $this->migration = $factory;
    }

    public function getMigrations(Updater $updater)
    {
        return array(
            $this->migration->db->addIndex('log_action', array('type', 'name(15)'), 'index_type_name'),
            $this->migration->db->addIndex('log_visit', array('idsite', 'visit_server_date'), 'index_idsite_date'),
            $this->migration->db->dropIndex('log_visit', 'index_idsite'),
            $this->migration->db->dropIndex('log_visit', 'index_visit_server_date'),
        );
    }

    public function doUpdate(Updater $updater)
    {
        $updater->executeMigrations(__FILE__, $this->getMigrations($updater));
    }
}
